/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.integration;

import com.hoshino.cti.Plugin.JEIPlugin;
import com.hoshino.cti.recipe.ReactorNeutronCollectorRecipe;
import com.hoshino.cti.register.CtiItem;
import com.mojang.blaze3d.vertex.PoseStack;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.providers.IGasProvider;
import mekanism.client.jei.ChemicalStackRenderer;
import mekanism.client.jei.MekanismJEI;
import mekanism.common.registries.MekanismGases;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ReactorNeutronCollectorRecipeCategory
implements IRecipeCategory<ReactorNeutronCollectorRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("cti", "reactor_neutron_collect");
    public static final ResourceLocation TEXTURE = new ResourceLocation("cti", "textures/gui/machine/neutron_collector_bg.png");
    private final IDrawable background;
    private final IDrawable icon;

    public ReactorNeutronCollectorRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 180, 59);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)CtiItem.reactor_neutron_collector.get()));
    }

    public RecipeType<ReactorNeutronCollectorRecipe> getRecipeType() {
        return JEIPlugin.NEUTRON_COLLECTING;
    }

    public Component getTitle() {
        return Component.m_237113_((String)"\u8fc7\u70ed\u94a0\u4e2d\u5b50\u7d20\u6536\u96c6");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ReactorNeutronCollectorRecipe recipe, IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 10, 33).addIngredient(MekanismJEI.TYPE_GAS, (Object)new GasStack((IGasProvider)MekanismGases.SUPERHEATED_SODIUM, 100000000L))).setCustomRenderer(MekanismJEI.TYPE_GAS, (IIngredientRenderer)new ChemicalStackRenderer(100000000L, 16, 16));
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 154, 33).addIngredient(MekanismJEI.TYPE_GAS, (Object)new GasStack((IGasProvider)MekanismGases.SODIUM, 100000000L))).setCustomRenderer(MekanismJEI.TYPE_GAS, (IIngredientRenderer)new ChemicalStackRenderer(100000000L, 16, 16));
        builder.addSlot(RecipeIngredientRole.INPUT, 82, 33).addItemStack(recipe.getCatalyst());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 118, 10).addItemStack(recipe.m_8043_());
    }

    public void draw(ReactorNeutronCollectorRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        MutableComponent efficiency = Component.m_237113_((String)"\u57fa\u7840\u6548\u7387: +").m_130940_(ChatFormatting.LIGHT_PURPLE).m_130946_(String.format("%.2f", Float.valueOf(recipe.getEfficiency()))).m_130946_("\u00d7");
        MutableComponent ConsumptionRate = Component.m_237113_((String)"\u50ac\u5316\u5242\u6d88\u8017: ").m_130940_(ChatFormatting.RED).m_130946_(String.format("%.2f", Float.valueOf(recipe.getConsumptionRate() * 1000.0f))).m_130946_("\u2030");
        Minecraft.m_91087_().f_91062_.m_92889_(stack, (Component)efficiency, 8.0f, 10.0f, 0);
        Minecraft.m_91087_().f_91062_.m_92889_(stack, (Component)ConsumptionRate, 8.0f, 18.0f, 0);
        super.draw((Object)recipe, recipeSlotsView, stack, mouseX, mouseY);
    }
}

